-- Formation

function setup()
    displayMode(FULLSCREEN)
    physics.gravity(0,0)
    touches = {}
    items = {}
    ships = {}
    for i=0,10 do
        local s = Ship {pos=vec2(0,50*i-400)}
        table.insert(ships, 1, s)
    end
    font("Futura-CondensedExtraBold")
end

function draw()
    background(83, 98, 125, 255)
    pushMatrix()
    translate(WIDTH/2,HEIGHT/2)   
    for i,s in ipairs(ships) do
        s:draw()
        if not isAlive(s) then table.remove(ships,i) end
    end
    for i,s in ipairs(items) do
        s:draw()
        if not isAlive(s) then table.remove(items,i) end
    end
    popMatrix()
    fill(255, 255, 255, 255)
    text("FIRE", 50,50)
end
function isAlive(s)
    if s.ttl and ElapsedTime > s.ttl then
        s:destroy()
    else
        return true
    end
end

function touched(touch)
    touches[touch.id] = touch
    local i,ti, tv = 1, 1, {}
    for id,v in pairs(touches) do
        if id == touch.id then i=ti end
        table.insert(tv, v)
        ti = ti + 1
    end
    local step = #tv
    
    -- check if button press
    if touch.state == BEGAN and touch.y < 100 then
        i,step=1,1
    end
    
    if #ships >= i then
        ships[i]:touched(touch, function()
            i = i + step
            return ships[i]
        end)
    end
    if touch.state == ENDED or touch.state == CANCELLED then
        touches[touch.id] = nil
    end
end

function collide(c)
    if c.state ~= BEGAN then return end
    local b = c.bodyA.info.bullet or c.bodyB.info.bullet
    local s = c.bodyA.info.ship or c.bodyB.info.ship
    if b then
        b.ttl = ElapsedTime-1
        if s then s.ttl = ElapsedTime+.2 end        
    end
    Explosion(c.position, 15)
end

